#region EDIS map for Windows 
 /*
  * EDIS map FOR WINDOWS
  * ~~~~~~~~~~~~~~~~~~~~
  * EDIS map is the primary document mapping tool used to create XML, EDIFACT and ANSI X.12 message translations. It is also
  * used to create and debug general-purpose scripts for use in EDIS events.
  * 
  * (c) EDIS Technologies Limited 19 
 */
#endregion 

#region Revision History
	//
	// 0000 10th Apr 2006 BRD Original version adapted from previous EDIS mapper version 4.1
   //
	//
#endregion

#region Documentation
 /*
  * Full documentation for EDIS map is contained in the EDIS publication "The EDIS map Functional Specification" 
 */
#endregion

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Xml;
using System.Xml.Schema;


namespace Transform
{
	public partial class frmEDISmap : Form
	{

        OpenFileDialog ofd;
        frmEDISmapMessageDefinition frmMessageDefinition;

		public frmEDISmap()
		{
			InitializeComponent();
		}

		//
		// frmEDISmap_Load()
		// ~~~~~~~~~~~~~~~~~
		private void frmEDISmap_Load(object sender, EventArgs e)
		{
			ConfigSettings.getPosition(this);
			frmEDISmapSplash frmSplash = new frmEDISmapSplash();
			frmSplash.MdiParent = this;
			frmSplash.Show();
		}

		//
		// openToolStripMenuItem_Click() 
		// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
		// Opens an existing message definition file selected via a File Open common dialog
		//
		private void openToolStripMenuItem_Click(object sender, EventArgs e)
		{
            ofd = new OpenFileDialog();
            if (ofd.ShowDialog() == DialogResult.OK)
            {
                frmMessageDefinition = new frmEDISmapMessageDefinition();
                frmMessageDefinition.displayMessageDefinition(ofd);
                frmMessageDefinition.Show();
            }
            else
                MessageBox.Show("The Cancel button was clicked or Esc was pressed");

		}

		//
		// frmEDISmap_FormClosing()
		// ~~~~~~~~~~~~~~~~~~~~~~~~
		private void frmEDISmap_FormClosing(object sender, FormClosingEventArgs e)
		{
			ConfigSettings.savePosition(this);
		}
	}
}